%Funkce pridani_hrany do reprezentace grafu (pomoc seznamu
%nsledovnk) pid hranu mezi uzly a, b.
% VSTUPY:
% a, b                    INT. sla koncovch uzl, mezi kter pid hranu.
% ukaz                    vektor. Vektor ukazatel, kter na pozici i udvaj,
%                         kde ve vektoru nasledovnk zanaj uzly sousedc s  
%                         uzlem i. 
% nasled                  vektor. Vektor nsledovnk.
% hrany                   vektor. Vektor oslovn hran.
% vzdal                   vektor. Vektor vzdlenost, pokud obsahuje
%                         nekoneno, znamen to, e tato hrana je neprjezdn.
% souradnice              matice souadnic jednotlivch uzl.
%
% VSTUPY:
% ukaza,nasleda,hranya,vzdala    vektory. Vektory reprezentujc nov
%                                vytvoen graf, s pidanou hranou.
function [ukaza,nasleda,hranya,vzdala]=pridani_hrany(a,b,ukaz,nasled,hrany,vzdal,souradnice)
ukaza=ukaz;
nasleda=nasled;
hranya=hrany; 
vzdal=vzdal(1,:); %z natench vzdlenost vyuijeme pouze udaje v km
vzdala=vzdal(1,:);
%peslovn vektoru ukazatel, naven hodnot pro uzly za uzlem a    
    for i=1:length(ukaz)-a  
        ukaza(a+i)=ukaz(a+i)+1;
    end;
    %peslovn vektoru ukazatel, naven hodnot pro uzly za uzlem b
    for l=1:length(ukaz)-b  
        ukaza(b+l)=ukaza(b+l)+1;
    end;
    %pidn hrany a-b
    for j=0:(length(nasled)-(ukaz(a+1)-1))
           if j==0
            nasleda(ukaz(a+1)+j)=b; %pidn uzlu b do nsledovnk uzlu a
            hranya(ukaz(a+1)+j)=max(hrany)+1; %pidn dalho dostupnho sla hrany
            vzdala(ukaz(a+1)+j)=sqrt(((souradnice(a,1)-souradnice(b,1))^2)+((souradnice(a,2)-souradnice(b,2))^2));
           else nasleda(ukaz(a+1)+j)=nasled(ukaz(a+1)+j-1); %posunut vem ostatnm nsledovnku o pozici dl
                hranya(ukaz(a+1)+j)=hrany(ukaz(a+1)+j-1);   %soubn posunut hran a vzdlenost
                vzdala(ukaz(a+1)+j)=vzdal(ukaz(a+1)+j-1);
           end;
     end;
     %pidn hrany b-a
     for m=0:(length(nasled)-(ukaz(b+1)-1))
           if m==0
              nasleda(ukaza(b+1)-1)=a; %pidn uzlu a do nsledovnk uzlu b
              hranya(ukaza(b+1)-1)=max(hrany)+1; %pidn dalho dostupnho sla hrany
              vzdala(ukaza(b+1)-1)=sqrt(((souradnice(a,1)-souradnice(b,1))^2)+((souradnice(a,2)-souradnice(b,2))^2));
           else nasleda(ukaza(b+1)-1+m)=nasled(ukaz(b+1)+m-1); %posunut vem ostatnm nsledovnku o pozici dl
                hranya(ukaza(b+1)-1+m)=hrany(ukaz(b+1)+m-1);   %soubn posunut hran a vzdlenost
                vzdala(ukaza(b+1)-1+m)=vzdal(ukaz(b+1)+m-1);
           end;
     end;
end